<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Gallery extends Model 
{

    protected $table = 'galleries';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function user()
    {
        return $this->hasOne('App\User');
    }

    public function category()
    {
        return $this->hasOne('App\Model\GalleryCategory', 'id', 'category_id');
    }

}